/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CachedTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTable;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.OrderedTableNameMap;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDataSet
extends AbstractDataSet
implements IDataSetConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CachedDataSet.class);
    private OrderedTableNameMap _tables;
    private DefaultTable _activeTable;

    public CachedDataSet() {
        this.initialize();
    }

    public CachedDataSet(IDataSet dataSet) throws DataSetException {
        super(dataSet.isCaseSensitiveTableNames());
        this.initialize();
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            ITable table = iterator.getTable();
            this._tables.add(table.getTableMetaData().getTableName(), new CachedTable(table));
        }
    }

    public CachedDataSet(IDataSetProducer producer) throws DataSetException {
        this(producer, false);
    }

    public CachedDataSet(IDataSetProducer producer, boolean caseSensitiveTableNames) throws DataSetException {
        super(caseSensitiveTableNames);
        this.initialize();
        producer.setConsumer(this);
        producer.produce();
    }

    private void initialize() {
        this._tables = super.createTableNameMap();
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        }
        ITable[] tables = this._tables.orderedValues().toArray(new ITable[0]);
        return new DefaultTableIterator(tables, reversed);
    }

    public void startDataSet() throws DataSetException {
        logger.debug("startDataSet() - start");
        this._tables = super.createTableNameMap();
    }

    public void endDataSet() throws DataSetException {
        logger.debug("endDataSet() - start");
        logger.debug("endDataSet() - the final tableMap is: " + this._tables);
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        logger.debug("startTable(metaData={}) - start", (Object)metaData);
        this._activeTable = new DefaultTable(metaData);
    }

    public void endTable() throws DataSetException {
        logger.debug("endTable() - start");
        String tableName = this._activeTable.getTableMetaData().getTableName();
        if (this._tables.containsTable(tableName)) {
            DefaultTable existingTable = (DefaultTable)this._tables.get(tableName);
            existingTable.addTableRows(this._activeTable);
        } else {
            this._tables.add(tableName, this._activeTable);
        }
        this._activeTable = null;
    }

    public void row(Object[] values) throws DataSetException {
        logger.debug("row(values={}) - start", values);
        this._activeTable.addRow(values);
    }
}

