/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.database.ForwardOnlyResultSetTable;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTable;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.database.ResultSetTableMetaData;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardOnlyResultSetTableFactory
implements IResultSetTableFactory {
    private static final Logger logger = LoggerFactory.getLogger(ForwardOnlyResultSetTableFactory.class);

    public IResultSetTable createTable(String tableName, String selectStatement, IDatabaseConnection connection) throws SQLException, DataSetException {
        if (logger.isTraceEnabled()) {
            logger.trace("createTable(tableName={}, selectStatement={}, connection={}) - start", new Object[]{tableName, selectStatement, connection});
        }
        return new ForwardOnlyResultSetTable(tableName, selectStatement, connection);
    }

    public IResultSetTable createTable(ITableMetaData metaData, IDatabaseConnection connection) throws SQLException, DataSetException {
        logger.trace("createTable(metaData={}, connection={}) - start", (Object)metaData, (Object)connection);
        return new ForwardOnlyResultSetTable(metaData, connection);
    }

    public IResultSetTable createTable(String tableName, PreparedStatement preparedStatement, IDatabaseConnection connection) throws SQLException, DataSetException {
        if (logger.isTraceEnabled()) {
            logger.trace("createTable(tableName={}, preparedStatement={}, connection={}) - start", new Object[]{tableName, preparedStatement, connection});
        }
        return this.createForwardOnlyResultSetTable(tableName, preparedStatement, connection);
    }

    ForwardOnlyResultSetTable createForwardOnlyResultSetTable(String tableName, PreparedStatement preparedStatement, IDatabaseConnection connection) throws SQLException, DataSetException {
        if (logger.isTraceEnabled()) {
            logger.trace("createForwardOnlyResultSetTable(tableName={}, preparedStatement={}, connection={}) - start", new Object[]{tableName, preparedStatement, connection});
        }
        connection.getConfig().getConfigurator().configureStatement(preparedStatement);
        ResultSet rs = preparedStatement.executeQuery();
        boolean caseSensitiveTableNames = connection.getConfig().getFeature("http://www.dbunit.org/features/caseSensitiveTableNames");
        ResultSetTableMetaData metaData = new ResultSetTableMetaData(tableName, rs, connection, caseSensitiveTableNames);
        ForwardOnlyResultSetTable table = new ForwardOnlyResultSetTable((ITableMetaData)metaData, rs);
        return table;
    }
}

