/*
 * Decompiled with CFR 0.152.
 */
package org.testng.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Maps;
import org.testng.collections.Sets;

public class SetMultiMap<K, V> {
    private Map<K, Set<V>> m_objects = Maps.newHashMap();

    public void put(K key, V method) {
        Set<V> l = this.m_objects.get(key);
        if (l == null) {
            l = Sets.newHashSet();
            this.m_objects.put(key, l);
        }
        l.add(method);
    }

    public Set<V> get(K key) {
        return this.m_objects.get(key);
    }

    public Set<K> getKeys() {
        return new HashSet<K>(this.m_objects.keySet());
    }

    public boolean containsKey(K k) {
        return this.m_objects.containsKey(k);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Set<K> indices = this.getKeys();
        for (K i : indices) {
            result.append("\n    ").append(i).append(" <-- ");
            for (V o : this.m_objects.get(i)) {
                result.append(o).append(" ");
            }
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.m_objects.size() == 0;
    }

    public int getSize() {
        return this.m_objects.size();
    }

    public Set<V> remove(K key) {
        return this.m_objects.remove(key);
    }

    public Set<Map.Entry<K, Set<V>>> getEntrySet() {
        return this.m_objects.entrySet();
    }

    public Collection<Set<V>> getValues() {
        return this.m_objects.values();
    }

    public void putAll(K k, Collection<V> values) {
        for (V v : values) {
            this.put(k, v);
        }
    }
}

