/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import java.util.Locale;
import org.testng.annotations.Test;
import org.uncommons.reportng.ReportMetadata;

public class ReportMetadataTest {
    @Test
    public void testDefaultLocale() {
        System.getProperties().remove("org.uncommons.reportng.locale");
        Locale.setDefault(new Locale("en", "GB"));
        ReportMetadata metadata = new ReportMetadata();
        String locale = metadata.getLocale().toString();
        assert (locale.equals("en_GB")) : "Wrong locale: " + locale;
    }

    @Test
    public void testLocaleLanguageOnly() {
        System.setProperty("org.uncommons.reportng.locale", "fr");
        ReportMetadata metadata = new ReportMetadata();
        String locale = metadata.getLocale().toString();
        assert (locale.equals("fr")) : "Wrong locale: " + locale;
    }

    @Test
    public void testLocaleLanguageAndCountry() {
        System.setProperty("org.uncommons.reportng.locale", "fr_CA");
        ReportMetadata metadata = new ReportMetadata();
        String locale = metadata.getLocale().toString();
        assert (locale.equals("fr_CA")) : "Wrong locale: " + locale;
    }

    @Test
    public void testLocaleLanguageCountryAndVariant() {
        System.setProperty("org.uncommons.reportng.locale", "fr_CA_POSIX");
        ReportMetadata metadata = new ReportMetadata();
        String locale = metadata.getLocale().toString();
        assert (locale.equals("fr_CA_POSIX")) : "Wrong locale: " + locale;
    }
}

