/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.testng.IClass;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestResult;
import org.testng.xml.XmlSuite;
import org.uncommons.reportng.AbstractReporter;
import org.uncommons.reportng.ReportNGException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitXMLReporter
extends AbstractReporter {
    private static final String RESULTS_KEY = "results";
    private static final String TEMPLATES_PATH = "org/uncommons/reportng/templates/xml/";
    private static final String RESULTS_FILE = "results.xml";
    private static final String REPORT_DIRECTORY = "xml";

    public JUnitXMLReporter() {
        super(TEMPLATES_PATH);
    }

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectoryName) {
        this.removeEmptyDirectories(new File(outputDirectoryName));
        File outputDirectory = new File(outputDirectoryName, REPORT_DIRECTORY);
        outputDirectory.mkdirs();
        Collection<TestClassResults> flattenedResults = this.flattenResults(suites);
        for (TestClassResults results : flattenedResults) {
            VelocityContext context = this.createContext();
            context.put(RESULTS_KEY, (Object)results);
            try {
                this.generateFile(new File(outputDirectory, String.valueOf(results.getTestClass().getName()) + '_' + RESULTS_FILE), "results.xml.vm", context);
            }
            catch (Exception ex) {
                throw new ReportNGException("Failed generating JUnit XML report.", ex);
            }
        }
    }

    private Collection<TestClassResults> flattenResults(List<ISuite> suites) {
        HashMap<IClass, TestClassResults> flattenedResults = new HashMap<IClass, TestClassResults>();
        for (ISuite suite : suites) {
            for (ISuiteResult suiteResult : suite.getResults().values()) {
                this.organiseByClass(suiteResult.getTestContext().getFailedConfigurations().getAllResults(), flattenedResults);
                this.organiseByClass(suiteResult.getTestContext().getSkippedConfigurations().getAllResults(), flattenedResults);
                this.organiseByClass(suiteResult.getTestContext().getFailedTests().getAllResults(), flattenedResults);
                this.organiseByClass(suiteResult.getTestContext().getSkippedTests().getAllResults(), flattenedResults);
                this.organiseByClass(suiteResult.getTestContext().getPassedTests().getAllResults(), flattenedResults);
            }
        }
        return flattenedResults.values();
    }

    private void organiseByClass(Set<ITestResult> testResults, Map<IClass, TestClassResults> flattenedResults) {
        for (ITestResult testResult : testResults) {
            this.getResultsForClass(flattenedResults, testResult).addResult(testResult);
        }
    }

    private TestClassResults getResultsForClass(Map<IClass, TestClassResults> flattenedResults, ITestResult testResult) {
        TestClassResults resultsForClass = flattenedResults.get(testResult.getTestClass());
        if (resultsForClass == null) {
            resultsForClass = new TestClassResults(testResult.getTestClass());
            flattenedResults.put(testResult.getTestClass(), resultsForClass);
        }
        return resultsForClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TestClassResults {
        private final IClass testClass;
        private final Collection<ITestResult> failedTests = new LinkedList<ITestResult>();
        private final Collection<ITestResult> skippedTests = new LinkedList<ITestResult>();
        private final Collection<ITestResult> passedTests = new LinkedList<ITestResult>();
        private long duration = 0L;

        private TestClassResults(IClass testClass) {
            this.testClass = testClass;
        }

        public IClass getTestClass() {
            return this.testClass;
        }

        void addResult(ITestResult result) {
            switch (result.getStatus()) {
                case 3: {
                    if (META.allowSkippedTestsInXML()) {
                        this.skippedTests.add(result);
                        break;
                    }
                }
                case 2: 
                case 4: {
                    this.failedTests.add(result);
                    break;
                }
                case 1: {
                    this.passedTests.add(result);
                }
            }
            this.duration += result.getEndMillis() - result.getStartMillis();
        }

        public Collection<ITestResult> getFailedTests() {
            return this.failedTests;
        }

        public Collection<ITestResult> getSkippedTests() {
            return this.skippedTests;
        }

        public Collection<ITestResult> getPassedTests() {
            return this.passedTests;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

