#pragma once

#include <map>
#include <string>

class HttpRequest
{
public:
	static bool Init();
	static bool LogIn(std::string userid, std::string password, std::string &token, std::string &roomid);
	static std::string GetWebServerUrl();
	static bool GetPullUrl(std::string token, std::map<std::string, std::string> &urls);
	static bool GetPushUrl(std::string token, std::map<std::string, std::string> &urls);

	static HttpRequest *GetInstance();
public:
	bool Load();

private:
	static HttpRequest *instance_;
private:
	std::string web_server_url_;
};