#pragma once

#include <string>
#include <list>
#include <map>

class ZgHttpClient
{
public:
	ZgHttpClient();
	~ZgHttpClient();

public:
	/**
	 *	@param	params		Ӧ name1=value1&name2=value2 ʽ
	 *	@param	headers		Headers
	 */
	bool Post(std::string request, std::string params, std::map<std::string, std::string> headers, std::string &response, std::string context_type = "Content-Type:application/x-www-form-urlencoded");

	bool Get(std::string &url, std::list<std::string> &headerlist, std::string &result, std::string &sError);
	bool DownLoad(std::string url, std::string filename, std::string &sError);
private:
	static size_t cbResponse(void *ptr, size_t size, size_t nmemb, void *userdata);
	static size_t cbDownLoadCallback(void *ptr, size_t size, size_t nmemb, void *userdata);
	static int cbProgressCallback(void *userdata, double dltotal, double dlnow, double ultotal, double ulnow);

	size_t Response(void *ptr, size_t size, size_t nmemb);
	size_t DownLoadCallback(void *ptr, size_t size, size_t nmemb);
	int ProgressCallback(double dltotal, double dlnow, double ultotal, double ulnow);

private:
	std::string buildResponse(int code, std::string msg);
private:
	void *curl_;
	std::string sError_;
	std::string sResult_;

	FILE *file_;
	std::string file_full_path_;
};