﻿// live_get_push_pull_address.cpp : 此文件包含 "main" 函数。程序执行将在此处开始并结束。
//


#include <iostream>

#include "../thirdparty/curl/http_request.h"

void printf_help()
{
	std::cout << "Enter room's password:";
}

int main()
{
	bool ret = HttpRequest::Init();
	if (!ret)
	{
		std::cout << "Init http failed!" << std::endl;
		return -1;
	}
	std::cout << "webserver address:" << HttpRequest::GetWebServerUrl() << std::endl;

	printf_help();

	std::string keyword;
	std::string token;
	std::string roomid;

	std::map<std::string, std::string> pull_urls;
	std::map<std::string, std::string> push_urls;

	while (std::cin >> keyword)
	{
		if (keyword == "q")
		{
			return 0;
		}

		if (keyword.empty())
		{
			std::cout << "password is empty ..." << std::endl;
			continue;
		}

		std::cout << std::endl;
		std::cout << "<------------------------------------------------------------------------------------------------------------------------" << std::endl;

		if (!HttpRequest::LogIn("offcn-live", keyword, token, roomid))
		{
			std::cout << "login webserver failed ..." << std::endl;
		}
		else
		{
			std::cout << "roomid:" << roomid << std::endl;
			std::cout << "token:" << token << std::endl;

			if (!HttpRequest::GetPushUrl(token, push_urls))
			{
				std::cout << "get push url failed ..." << std::endl;
			}
			else
			{
				std::cout << std::endl;
				std::cout << "push url:" << std::endl;

				std::map<std::string, std::string>::iterator itor;
				for (itor = push_urls.begin(); itor != push_urls.end(); itor++)
				{
					std::cout << itor->second << std::endl;
				}
			}

			if (!HttpRequest::GetPullUrl(token, pull_urls))
			{
				std::cout << "get pull url failed ..." << std::endl;
			}
			else
			{
				std::cout << std::endl;
				std::cout << "pull url:" << std::endl;

				std::map<std::string, std::string>::iterator itor;
				for (itor = pull_urls.begin(); itor != pull_urls.end(); itor++)
				{
					std::cout << itor->first << ":" << itor->second << std::endl;
				}
			}
		}
		std::cout << "------------------------------------------------------------------------------------------------------------------------>" << std::endl;
		
		keyword = "";
		std::cout << std::endl << std::endl;
		printf_help();
	}
	return 0;
}
