#pragma once

#include <string>

#include "MQTTAsync.h"

namespace offcn
{
	class CmdObserver
	{
	public:
		virtual void OnServerConnectSuccess() = 0;
		virtual void OnServerConnectFailure() = 0;

		virtual void OnServerSubscribeSuccess() = 0;
		virtual void OnServerSubscribeFailure() = 0;

		virtual void OnServerMessageArrived(std::string topic, std::string message) = 0;
	};
	class MqttWrapper
	{
	public:
		MqttWrapper(CmdObserver *observer);

	public:
		bool ConnectMqttServer(std::string localID);
		bool SubscribeTopic(std::string topic);
		int  SendRequest(std::string &topic, std::string &request);

	public:
		//connect callback
		static void mqttConnectSuccess(void *context, MQTTAsync_successData *response)
		{
			MqttWrapper *wrapper = (MqttWrapper *)context;
			wrapper->OnMqttConnectSuccess(response);
		}
		void OnMqttConnectSuccess(MQTTAsync_successData *response);

		static void mqttConnectFailure(void *context, MQTTAsync_failureData *response)
		{
			MqttWrapper *wrapper = (MqttWrapper *)context;
			wrapper->OnMqttConnectFailure(response);
		}
		void OnMqttConnectFailure(MQTTAsync_failureData *response);

		//subscribe callback
		static void mqttSubscribeSuccess(void *context, MQTTAsync_successData *response)
		{
			MqttWrapper *wrapper = (MqttWrapper *)context;
			wrapper->OnMqttSubscribeSuccess(response);
		}
		void OnMqttSubscribeSuccess(MQTTAsync_successData *response);

		static void mqttSubscribeFailure(void *context, MQTTAsync_failureData *response)
		{
			MqttWrapper *wrapper = (MqttWrapper *)context;
			wrapper->OnMqttSubscribeFailure(response);
		}
		void OnMqttSubscribeFailure(MQTTAsync_failureData *response);

		//receive callback
		static int mqttMessageCallback(void *context, char *topicName, int topicNameLen, MQTTAsync_message *message)
		{
			MqttWrapper *wrapper = (MqttWrapper *)context;
			return wrapper->mqttRecvMessage(topicName, topicNameLen, message);
		}
		int mqttRecvMessage(char *topicName, int topicNameLen, MQTTAsync_message *message);
	private:
		MQTTAsync	mqtt_client_;
		CmdObserver *observer_;

		std::string		dst_topic_;
	};
}