#include "mqtt_wrapper.h"

#include <stdlib.h>

namespace offcn
{
	static const std::string kMqttUrl = "test-mqq.offcncloud.com";//"192.168.43.12";
	static const std::string kUserName = "admin";
	static const std::string kPassWord = "public";

	static struct Options
	{
		char *connection;
		int verbose;
		int test_no;
		int size;
		int MQTTVersion;
		int iterations;
	}options;

	MqttWrapper::MqttWrapper(CmdObserver *observer)
		:mqtt_client_(NULL),
		observer_(observer)
	{
	}
	bool MqttWrapper::ConnectMqttServer(std::string localID)
	{
		options.connection = (char *)malloc(128);
		memset(options.connection, 0, 128);
		memcpy(options.connection, kMqttUrl.c_str(), kMqttUrl.size());

		options.verbose = 0;
		options.test_no = -1;
		options.size = 10000;
		options.MQTTVersion = MQTTVERSION_3_1;
		options.iterations = 1;

		MQTTAsync_connectOptions opts = MQTTAsync_connectOptions_initializer;
		MQTTAsync_willOptions wopts = MQTTAsync_willOptions_initializer;

		std::string clientid = localID;
		int nRet = MQTTAsync_create(&mqtt_client_, options.connection, clientid.c_str(), MQTTCLIENT_PERSISTENCE_NONE, NULL);
		if (nRet != MQTTASYNC_SUCCESS)
		{
			return false;
		}

		nRet = MQTTAsync_setCallbacks(mqtt_client_, this, NULL, mqttMessageCallback, NULL);

		std::string new_token = kPassWord;
		opts.keepAliveInterval = 20;
		opts.cleansession = 1;
		opts.username = kUserName.c_str();
		opts.password = kPassWord.c_str();
		opts.MQTTVersion = options.MQTTVersion;
		opts.cleansession = true;

		opts.will = NULL;
		opts.onSuccess = mqttConnectSuccess;
		opts.onFailure = mqttConnectFailure;
		opts.context = this;
		opts.connectTimeout = 5;

		nRet = MQTTAsync_connect(mqtt_client_, &opts);
		if (nRet != MQTTASYNC_SUCCESS)
		{
			MQTTAsync_destroy(&mqtt_client_);
			mqtt_client_ = NULL;
			return false;
		}

		return true;
	}
	bool MqttWrapper::SubscribeTopic(std::string topic)
	{
		dst_topic_ = topic;

		MQTTAsync_responseOptions opts = MQTTAsync_responseOptions_initializer;
		opts.onSuccess = mqttSubscribeSuccess;
		opts.onFailure = mqttSubscribeFailure;
		opts.context = this;

		int nRet = MQTTAsync_subscribe(mqtt_client_, topic.c_str(), 2, &opts);
		if (nRet != MQTTASYNC_SUCCESS)
		{
			return false;
		}

		return true;
	}
	int  MqttWrapper::SendRequest(std::string &topic, std::string &request)
	{
		MQTTAsync_message msg = MQTTAsync_message_initializer;
		msg.payload = (void *)request.c_str();
		msg.payloadlen = (int)request.length();
		msg.qos = 2;
		msg.retained = 0;

		int nRet = MQTTAsync_send(mqtt_client_, topic.c_str(), msg.payloadlen, msg.payload, msg.qos, msg.retained, NULL);
		if (nRet == MQTTASYNC_SUCCESS)
		{
			return 0;
		}

		return -1;
	}

	void MqttWrapper::OnMqttConnectSuccess(MQTTAsync_successData *response)
	{
		if (observer_)
		{
			observer_->OnServerConnectSuccess();
		}
	}
	void MqttWrapper::OnMqttConnectFailure(MQTTAsync_failureData *response)
	{
		if (observer_)
		{
			observer_->OnServerConnectFailure();
		}
	}
	void MqttWrapper::OnMqttSubscribeSuccess(MQTTAsync_successData *response)
	{
		if (observer_)
		{
			observer_->OnServerSubscribeSuccess();
		}
	}
	void MqttWrapper::OnMqttSubscribeFailure(MQTTAsync_failureData *response)
	{
		if (observer_)
		{
			observer_->OnServerSubscribeFailure();
		}
	}
	int MqttWrapper::mqttRecvMessage(char *topicName, int topicNameLen, MQTTAsync_message *message)
	{
		if (dst_topic_.compare(topicName) != 0) return 1;
		if (message->payloadlen <= 0) return 1;

		std::string topic;
		topic.append(topicName, topicNameLen);

		std::string msg;
		msg.append((char *)message->payload, message->payloadlen);

		if (observer_)
		{
			observer_->OnServerMessageArrived(topic, msg);
		}

		MQTTAsync_freeMessage(&message);
		MQTTAsync_free(topicName);

		return 1;
	}
}