#pragma once

#include <string>
#include <map>

/*
Request format
{
"message_id":"xxxx",
"method":"join",
"from_id":"xxxx",
"to_id":"xxxx"
"data":
	{}
}

Response format
{
"message_id":"xxxx",
"result_code":"ok" or
"result_code":"no auth"
"data":
	{}
}

client to server:
join
update

client to client:
offer/answer

server to client:
publishers

*/

namespace offcn
{
	typedef std::map<std::string, std::string> ReqValue;

	class MqttRequest
	{
	public:
		/**
		 * client to server
		 */
		static std::string JoinRequest(std::string message_id, std::string from_id);
		static std::string UpdateRequest(std::string message_id, std::string from_id, std::string pull_type);
		/**
		 *	client to client
		 */
		static std::string OfferRequest(std::string message_id, std::string from_id, std::string to_id, std::string candidate);
		static std::string AnswerRequest(std::string message_id, std::string from_id, std::string to_id, std::string candidate);
		/**
		 *	server to client
		 */
		static std::string PublishersRequest(std::string message_id, std::string to_id, std::string publisher_id);

		/**
		 *	public
		 */
		static bool ParseRequestType(std::string request, std::string &type, std::string &error);

		/**
		 * client to server
		 */
		static bool ParseJoinRequest(std::string request, ReqValue &values, std::string &error);
		static bool ParseUpdateRequest(std::string request, ReqValue &values, std::string &error);
		/**
		 *	client to client
		 */
		static bool ParseOfferRequest(std::string request, ReqValue &values, std::string &error);
		static bool ParseAnswerRequest(std::string request, ReqValue &values, std::string &error);
		/**
		 *	server to client
		 */
		static bool ParsePublishersRequest(std::string request, ReqValue &values, std::string &error);

		/**
		 * build response
		 */
		static std::string BuildResponse(std::string message_id, std::string result_code);
	};
}