#include "mqtt_request.h"
#include "json/json.h"

namespace offcn
{
	static bool GetJsonValue(std::string &response, Json::Value &root)
	{
		Json::CharReaderBuilder readerBuilder;
		std::unique_ptr<Json::CharReader> const reader(readerBuilder.newCharReader());
		const char *start_pos = response.c_str();
		std::string err;
		if (!reader->parse(start_pos, start_pos + response.length(), &root, &err))
		{
			return false;
		}

		return true;
	}

	std::string MqttRequest::JoinRequest(std::string message_id, std::string from_id)
	{
		Json::Value root;
		Json::StreamWriterBuilder wBuilder;

		root["message_id"] = message_id;
		root["method"] = "join";
		root["from_id"] = from_id;
		
		return Json::writeString(wBuilder, root);
	}
	std::string MqttRequest::UpdateRequest(std::string message_id, std::string from_id, std::string pull_type)
	{
		Json::Value root;
		Json::StreamWriterBuilder wBuilder;

		root["message_id"] = message_id;
		root["method"] = "update";
		root["from_id"] = from_id;
		root["pull_type"] = pull_type;

		return Json::writeString(wBuilder, root);
	}
	
	std::string MqttRequest::OfferRequest(std::string message_id, std::string from_id, std::string to_id, std::string candidate)
	{
		Json::Value root;
		Json::StreamWriterBuilder wBuilder;

		root["message_id"] = message_id;
		root["method"] = "offer";
		root["from_id"] = from_id;
		root["to_id"] = to_id;
		root["candidate"] = candidate;

		return Json::writeString(wBuilder, root);
	}
	std::string MqttRequest::AnswerRequest(std::string message_id, std::string from_id, std::string to_id, std::string candidate)
	{
		Json::Value root;
		Json::StreamWriterBuilder wBuilder;

		root["message_id"] = message_id;
		root["method"] = "answer";
		root["from_id"] = from_id;
		root["to_id"] = to_id;
		root["candidate"] = candidate;

		return Json::writeString(wBuilder, root);
	}
	std::string MqttRequest::PublishersRequest(std::string message_id, std::string to_id, std::string publisher_id)
	{
		Json::Value root;
		Json::StreamWriterBuilder wBuilder;

		root["method"] = "publishers";
		root["id"] = message_id;

		return Json::writeString(wBuilder, root);
	}

	bool MqttRequest::ParseRequestType(std::string request, std::string &type, std::string &error)
	{
		Json::Value root;
		if (!GetJsonValue(request, root))
		{
			error = "json format error";
			return false;
		}

		if (!root["method"])
		{
			error = "param error";
			return false;
		}

		type = root["method"].asString();

		return true;
	}

	bool MqttRequest::ParseJoinRequest(std::string request, ReqValue &values, std::string &error)
	{
		Json::Value root;
		if (!GetJsonValue(request, root))
		{
			error = "json format error";
			goto Error;
		}
		
		if (!root["method"] || !root["id"])
		{
			error = "param error";
			goto Error;
		}

		values["method"] = root["method"].asString();
		values["id"] = root["id"].asString();

		return true;

	Error:
		values["method"] = "";
		values["id"] = "";

		return false;
	}
	bool MqttRequest::ParseUpdateRequest(std::string request, ReqValue &values, std::string &error)
	{
		Json::Value root;
		if (!GetJsonValue(request, root))
		{
			error = "json format error";
			return false;
		}

		if (!root["message_id"] || !root["method"] || !root["from_id"] || !root["pull_type"])
		{
			error = "param error";
			return false;
		}

		values["message_id"] = root["message_id"].asString();
		values["method"] = root["method"].asString();
		values["from_id"] = root["from_id"].asString();
		values["pull_type"] = root["pull_type"].asString();

		return true;
	}

	bool MqttRequest::ParseOfferRequest(std::string request, ReqValue &values, std::string &error)
	{
		Json::Value root;
		if (!GetJsonValue(request, root))
		{
			error = "json format error";
			return false;
		}

		if (!root["message_id"] || !root["method"] || !root["from_id"] || !root["to_id"] || !root["candidate"])
		{
			error = "param error";
			return false;
		}

		values["message_id"] = root["message_id"].asString();
		values["method"] = root["method"].asString();
		values["from_id"] = root["from_id"].asString();
		values["to_id"] = root["from_id"].asString();
		values["candidate"] = root["candidate"].asString();

		return true;
	}
	bool MqttRequest::ParseAnswerRequest(std::string request, ReqValue &values, std::string &error)
	{
		return ParseOfferRequest(request, values, error);
	}

	bool MqttRequest::ParsePublishersRequest(std::string request, ReqValue &values, std::string &error)
	{
		Json::Value root;
		if (!GetJsonValue(request, root))
		{
			error = "json format error";
			return false;
		}

		if (!root["message_id"] || !root["method"] || !root["publishers"] || !root["to_id"])
		{
			error = "param error";
			return false;
		}

		values["message_id"] = root["message_id"].asString();
		values["method"] = root["method"].asString();
		values["publishers_id"] = root["publishers_id"].asString();
		values["to_id"] = root["to_id"].asString();

		return true;
	}
	std::string MqttRequest::BuildResponse(std::string message_id, std::string result_code)
	{
		Json::Value root;
		Json::StreamWriterBuilder wBuilder;

		root["method"] = "login";
		root["id"] = message_id;
		root["result_code"] = result_code;

		return Json::writeString(wBuilder, root);
	}
}