#pragma once

#include "mqtt_wrapper.h"
#include <map>

namespace offcn
{
	class CmdProcesserObserver
	{
	public:
		virtual void OnReceiveRemoteCandidate(std::string &remote_id, std::string &type, std::string &candidate) = 0;
	};

	class CmdProcesserClient : public CmdObserver
	{
	public:
		CmdProcesserClient();
		~CmdProcesserClient();

	public:
		void SetLocalID(std::string id, CmdProcesserObserver *observer);
		bool Connect();
		bool SubscribeTopic();
		/**
		 *	@param	type	offer/answer
		 */
		bool SendLocalCandidate(std::string tid, std::string type, std::string candidate);

	public:
		/**
		 * CmdObserver
		 */
		virtual void OnServerConnectSuccess();
		virtual void OnServerConnectFailure();
		virtual void OnServerSubscribeSuccess();
		virtual void OnServerSubscribeFailure();
		virtual void OnServerMessageArrived(std::string topic, std::string message);

	public:
		void OnParsePublishersSuccess(std::string message_id, std::string publishers_id);
		void OnParseFailure(std::string message_id, std::string from_id, std::string error);

		void OnParseOfferOrAnswerSuccess(std::string message_id, std::string type, std::string to_id, std::string candidate);

	private:
		MqttWrapper	*mqtt_wrapper_;
	private:
		std::map<std::string, std::string> publisher_list_;
		std::map<std::string, std::string> subscriber_list_;
	private:
		std::string local_id_;
	private:
		CmdProcesserObserver	*observer_;
	};
}