#pragma once

#include "mqtt_wrapper.h"
#include <map>

namespace offcn
{
	class CmdProcesserServer : public CmdObserver
	{
	public:
		CmdProcesserServer();
		~CmdProcesserServer();

	public:
		bool Connect();
		bool SubscribeTopic();

	public:
		/**
		 * CmdObserver
		 */
		virtual void OnServerConnectSuccess();
		virtual void OnServerConnectFailure();
		virtual void OnServerSubscribeSuccess();
		virtual void OnServerSubscribeFailure();
		virtual void OnServerMessageArrived(std::string topic, std::string message);

	private:
		void OnParseJoinSuccess(std::string from_id);
		void OnParseFailure(std::string message_id, std::string from_id, std::string error);

		void OnParseUpdateSuccess(std::string message_id, std::string from_id, std::string pull_type);

	private:
		MqttWrapper	*mqtt_wrapper_;

	private:
		std::map<std::string, std::string> client_lists_;
	};
}