#include "cmd_processer_server.h"
#include "mqtt_request.h"
#include "json/json.h"

namespace offcn
{
	static const std::string kGlobalTopic = "topic_for_turn_test";
	static const std::string kLocalID = "mqtt_server_for_turn_test";

	CmdProcesserServer::CmdProcesserServer()
		:mqtt_wrapper_(NULL)
	{
		mqtt_wrapper_ = new offcn::MqttWrapper(this);
	}
	CmdProcesserServer::~CmdProcesserServer()
	{
		if (mqtt_wrapper_)
		{
			delete mqtt_wrapper_;
			mqtt_wrapper_ = NULL;
		}
	}

	bool CmdProcesserServer::Connect()
	{
		return mqtt_wrapper_->ConnectMqttServer(kLocalID);
	}
	bool CmdProcesserServer::SubscribeTopic()
	{
		return mqtt_wrapper_->SubscribeTopic(kGlobalTopic);
	}

	/**
	 * CmdObserver
	 */
	void CmdProcesserServer::OnServerConnectSuccess()
	{
		printf("connect mqtt server success!\n");

		SubscribeTopic();
	}
	void CmdProcesserServer::OnServerConnectFailure()
	{
		printf("connect mqtt server failure!\n");
	}
	void CmdProcesserServer::OnServerSubscribeSuccess()
	{
		printf("subscribe topic success!\n");
	}
	void CmdProcesserServer::OnServerSubscribeFailure()
	{
		printf("subscribe topic failure!\n");
	}
	void CmdProcesserServer::OnServerMessageArrived(std::string topic, std::string message)
	{
		printf("\nreceive message : topic = %s, context : %s\n", topic.c_str(), message.c_str());

		std::string method;
		std::string error;
		ReqValue	values;
		if (!MqttRequest::ParseRequestType(message, method, error))
		{
			printf("Error : Parse request error\n");
			return;
		}

		if (method.compare("login") == 0)
		{
			if (MqttRequest::ParseJoinRequest(message, values, error))
			{
				OnParseJoinSuccess(values["id"]);
			}
			else
			{
				OnParseFailure(values["id"], values["id"], error);
			}
		}
	}

	void CmdProcesserServer::OnParseJoinSuccess(std::string from_id)
	{
		std::string response;
		if (client_lists_.find(from_id) != client_lists_.end())
		{
			response = MqttRequest::BuildResponse(from_id, "id exist");
			mqtt_wrapper_->SendRequest(from_id, response);

			return;
		}
		else
		{
			client_lists_.insert(std::pair<std::string, std::string>(from_id, from_id));

			Json::Value root;
			Json::Value root1;
			Json::Value ids;
			Json::StreamWriterBuilder wBuilder;

			root["method"] = "publishers";

			root1["method"] = "online";
			root1["id"] = from_id;

			printf("\n----------------online list--------------------\n");
			std::map<std::string, std::string>::iterator itor;
			for (itor = client_lists_.begin(); itor != client_lists_.end(); itor++)
			{
				if (itor->first.compare(from_id) != 0)
				{
					//response = MqttRequest::PublishersRequest("sdf", from_id, itor->first);
					//mqtt_wrapper_->SendRequest(itor->first, response);

					ids.append(itor->first);
				}
				printf("id = %s, pull type = %s\n", itor->first.c_str(), itor->second.c_str());
			}
			printf("\n-----------------------------------------------\n");

			root["ids"] = ids;

			std::string req = Json::writeString(wBuilder, root);
			mqtt_wrapper_->SendRequest(from_id, req);

			//req = Json::writeString(wBuilder, root1);
			//std::string topic = kGlobalTopic;
			//mqtt_wrapper_->SendRequest(topic, req);
		}
	}
	void CmdProcesserServer::OnParseFailure(std::string message_id, std::string from_id, std::string error)
	{
		std::string response = MqttRequest::BuildResponse(message_id, error);
		mqtt_wrapper_->SendRequest(from_id, response);
	}

	void CmdProcesserServer::OnParseUpdateSuccess(std::string message_id, std::string from_id, std::string pull_type)
	{
		std::string response;
		if (client_lists_.find(from_id) == client_lists_.end())
		{
			response = MqttRequest::BuildResponse(message_id, "id is not exist");
			mqtt_wrapper_->SendRequest(from_id, response);

			return;
		}
		else
		{
			client_lists_.insert(std::pair<std::string, std::string>(from_id, pull_type));
			response = MqttRequest::BuildResponse(message_id, "ok");

			printf("\n------------------------------------\n");
			std::map<std::string, std::string>::iterator itor;
			for (itor = client_lists_.begin(); itor != client_lists_.end(); itor++)
			{
				printf("id = %s, pull type = %s\n", itor->first.c_str(), itor->second.c_str());
			}
			printf("------------------------------------\n");
		}
	}
}