package model

import (
	"github.com/gogf/gf/container/gset"
	"ppt_server/app/model/internal"
)

type (
	XyuRoom internal.XyuRoom

	XyuRoomFiles internal.XyuRoomFiles

	// 客户端上传课件请求参数
	FileUploadRequest struct {
		RoomNum  string `p:"room_num" v:"required#房间号不能为空"`
		Name     string `p:"name" v:"required#课件名称不能为空"`
		Nickanem string `p:"nickname" v:"required#用户昵称不能为空"`
		Type     int    `p:"type"`
		Url      string `p:"url" v:"required#上传课件地址不能为空"`
		Uuid     string `p:"uuid" v:"required#上传者UUID不能为空"`
	}

	// web365解析文件返回信息
	UploadFileInfo struct {
		FileName   string `json:"FileName"`
		FileSize   int64  `json:"FileSize"`
		PageCount  int    `jons:"PageCount"`
		SlideCount int    `json:"SlideCount"`
		SheetCount int    `json:"SheetCount"`
	}

	//OssPacked
	Packed struct {
		FileName      string          `json:"fileName"`
		Hash          string          `json:"json"`
		ImagesName    *gset.Set       `json:"imagesName"`
		OssImagesPath string          `json:"ossImagesPath"`
		ImageInfos    [][]interface{} `json:"imageInfos"`
	}

	// 服务端通知返回信息
	NotifyResponse struct {
		Code int64  `json:"code"`
		Msg  string `json:"msg"`
	}
)
