package models

import (
	"fmt"
	"log"
	"ppt_server/utils"
	"sync"

	"github.com/astaxie/beego/orm"

	_ "github.com/go-sql-driver/mysql"
)

var (
	user        string = utils.ConfigObject.DBuser
	pass        string = utils.ConfigObject.DBpass
	host        string = utils.ConfigObject.DBHost
	port        string = utils.ConfigObject.DBPort
	dbname      string = utils.ConfigObject.DBname
	charset     string = utils.ConfigObject.DBcharset
	driver      string = utils.ConfigObject.Driver
	maxFreeConn int    = utils.ConfigObject.MaxFreeLink
	maxConn     int    = utils.ConfigObject.MaxLink
	prefix      string = utils.ConfigObject.DBprefix
)

type XyuRoom struct {
	Id                int    `json:"id"`
	RoomNum           string `json:"room_num"`
	StartTime         string `json:"start_time"`
	EndTime           string `json:"end_time"`
	Status            int    `json:"status"`
	TeacherPassword   string `json:"teacher_password"`
	AssistantPassword string `json:"assistant_password"`
	StudentPassword   string `json:"student_password"`
	HostPassword      string `json:"host_password"`
	SupervisePassword string `json:"supervise_password"`
	IsRecording       int
	RoomType          int `json:"room_type"`
	ActualPush        int
}

type XyuSmallRoom struct {
	Id       int
	RoomId   int
	MaxPush  int
	RoomMode int
	AllowMic int
}

type XyuSmallRoomWindow struct {
	Id         int
	RoomNum    string `json:"room_num"`
	WId        int    `json:"wndindex"`
	EId        string `json:"e_id"`
	PId        string `json:"pid"`
	Role       string `json:"role"`
	UserId     string `json:"user_id"`
	SetType    int    `json:"set_type"`
	CreateTime string `json:"create_time"`
	Status     int
}

type XyuRoomUsers struct {
	Id      int    `json:"id"`
	Role    string `json:"role"`
	RoomNum string `json:"room_num"`
	Token   string `json:"token"`
}

type XyuSmallRoomPeople struct {
	Id        int
	RoomNum   string `pk;json:"room_num";`
	Teacher   int
	Assistant int
	Student   int
	Host      int
	Supervise int
}

type XyuSmallRoomRecord struct {
	Id         int
	RoomNum    string
	Sessid     string
	Peerid     string
	RecordName string
	TimeStamp  string
}

type XyuSmallTempFiles struct {
	Id       int
	RoomNum  string `form:"room_num"`
	Name     string `form:"name"`
	Nickanem string `form:"nickname"`
	Type     int    `form:"type"`
	Url      string `form:"url"`
	Time     string `form:"time"'`
	Uuid     string `form:"uuid"`
	Status   int
}

type XyuRoomFiles struct {
	Id     int
	RoomId int
	Name   string
}

var once sync.Once

func init() {
	once.Do(func() {
		init_mysql()
	})
}

func init_mysql() {
	dbConfStr := fmt.Sprintf("%s:%s@tcp(%s:%s)/%s?charset=%s",
		user, pass, host, port, dbname, charset)
	log.Println("dbconf => ", dbConfStr)
	_ = orm.RegisterDriver(driver, orm.DRMySQL)
	err := orm.RegisterDataBase("default", driver, dbConfStr, maxFreeConn, maxConn)
	if err != nil {
		log.Println("db connect error => ", err)
		return
	}
	orm.RegisterModel(new(XyuRoom), new(XyuRoomUsers), new(XyuSmallRoom), new(XyuSmallRoomWindow),
		new(XyuSmallRoomPeople), new(XyuSmallRoomRecord), new(XyuSmallTempFiles), new(XyuRoomFiles))
	//orm.Debug = true
	log.Println("MySQL connect success")
}
