package service

import (
	"ppt_server/app/dao"
	"ppt_server/app/model"
	"ppt_server/packed/file"

	"github.com/gogf/gf/frame/g"
)

var File = &fileService{
	Done: make(chan error),
	Ok:   make(chan bool),
}

type fileService struct {
	Done chan error
	Ok   chan bool
}

// 上传课件
func (f *fileService) Upload(file *file.ObtainFile) {
	// 检查房间是否存在
	var room model.XyuRoom
	err := dao.XyuRoom.Where(dao.XyuRoom.Columns.RoomNum, file.R.RoomNum).Scan(&room)

	// 上传操作
	go file.Worker(err)

	// 回调通知
	select {
	case <-f.Done:
		// 上传失败
		file.Fail()
		return
	case <-f.Ok:
		// 上传成功
		count, err := dao.XyuRoomFile.Where(dao.XyuRoomFile.Columns.RoomId, room.Id).
			Where(dao.XyuRoomFile.Columns.Name, file.R.Name).Count()
		if err != nil {
			g.Log().Async().Errorf("Mysql Err: %s\n", err)
			return
		}
		// 数据库已经存在不需要通知
		if count == 1 {
			return
		}
		file.Success(room.Id)
		return
	}
}
