package api

import (
	"ppt_server/app/model"
	"ppt_server/app/service"
	"ppt_server/library/response"
	"ppt_server/packed/file"

	"github.com/gogf/gf/net/ghttp"
)

var File = fileApi{}

type fileApi struct{}

func (f *fileApi) Index(r *ghttp.Request) {
	response.Success(r)
}

/**
 * @Author lifeifei
 * @Date 9:44 上午 2021/7/22
 * @Summary 课件上传接口
 * @Tags  客户端通过接口上传课件
 * @Produce json
 * @Router  POST /file/upload
 * @Param room_num formData string true "房间名称"
 * @Param name formData string true "课件名称"
 * @Param nickname formData string true "用户昵称"
 * @Param type formData string true "文件类型"
 * @Param url formData int true "课件地址"
 * @Param uuid formData string true "用户唯一标识"
 * @Return {"code":0,"data":null,"msg":"成功"}
 **/
func (f *fileApi) Upload(r *ghttp.Request) {
	var req model.FileUploadRequest
	if err := r.Parse(&req); err != nil {
		response.Fail(r, err)
	}
	// 检测课件格式
	parserFile, err := file.Upload(&req, service.File.Done, service.File.Ok)
	if err != nil {
		response.Fail(r, err)
	}
	go service.File.Upload(parserFile)
	response.Success(r)
}
