/**
* @Authore: lifeifei
* @Date: 2021/1/25 10:11 上午
 */
package upload

import (
	"github.com/astaxie/beego/orm"
	beeLogger "github.com/beego/bee/logger"
	"mime"
	Qurl "net/url"
	"path"
	"ppt_server/models"
	"strings"
	"time"
)

type PPT struct {
	request *models.XyuSmallTempFiles
}

func (p *PPT) Transform() (err error) {
	maps := make(map[string]interface{})
	o := orm.NewOrm()
	var room models.XyuRoom
	err = o.QueryTable("xyu_room").Filter("room_num", p.request.RoomNum).One(&room)
	if err != nil {
		beeLogger.Log.Errorf("获取房间信息失败:%s", err)
		return
	}
	maps["url"] = p.request.Url
	maps["room_id"] = room.Id
	maps["id"] = time.Now().Unix()
	maps["is_courseware"] = "1"
	maps["private"] = "1"
	maps["nickname"] = p.request.Nickanem
	maps["name"] = p.request.Name
	maps["time"] = time.Now().Format("2006-01-02 15:04:0")
	maps["uuid"] = p.request.Uuid

	switch p.request.Type {
	case 1:
		maps["is_material"] = 1
	case 2:
		maps["is_courseware"] = 1
	case 3:
		maps["is_titlebook"] = 1
	}

	objectName := p.request.Url[strings.Index(p.request.Url, "com/")+4:]
	url, _ := Qurl.QueryUnescape(p.request.Url)
	filename := path.Base(url)
	ext := path.Ext(filename)
	slice_path := strings.Split(objectName, "/")
	maps["file_name_hash"] = slice_path[3]
	maps["hash"] = slice_path[2]
	var docType string
	if strings.Contains(ext, "ppt") || strings.Contains(ext, "pptx") {
		docType = "4"
	} else if strings.Contains(ext, "doc") || strings.Contains(ext, "docx") {
		docType = "2"
	} else if strings.Contains(ext, "xls") || strings.Contains(ext, "xlsx") {
		docType = "3"
	} else if strings.Contains(ext, "pdf") {
		docType = "1"
	}
	maps["doc_type"] = docType
	_ = mime.AddExtensionType(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation")
	maps["type"] = mime.TypeByExtension(ext)
	maps["path"] = objectName

	if err = RM.Send(maps); err != nil {
		beeLogger.Log.Errorf("Send Error: %s", err)
		_ = UpdateFileError("6", maps["uuid"].(string), maps["roomNum"].(string), objectName)
		return
	}

	return nil
}
