/**
* @Authore: lifeifei
* @Date: 2021/1/25 10:47 上午
 */
package upload

import (
	"encoding/json"
	"fmt"
	"sync"

	beeLogger "github.com/beego/bee/logger"
	"github.com/streadway/amqp"
)

var once sync.Once
var RM *RabbitMQ
type RabbitMQ struct {
	connection   *amqp.Connection
	channel      *amqp.Channel

}

func (r *RabbitMQ) mqConnect() error {

	var err error

	RabbitUrl := fmt.Sprintf("amqp://%s:%s@%s:%d/",
		"video",
		"1fqH4WFR19uckgRyHzgISw",
		"test-rmq.offcncloud.com/",
		5672)

	if r.connection, err = amqp.DialConfig(RabbitUrl, amqp.Config{Vhost: "v.ofc.office"}); err != nil {
		beeLogger.Log.Errorf("RabbitMQ Server Connect Fail: %s", err)
		return err
	}

	c, err := r.connection.Channel()
	if err != nil {
		beeLogger.Log.Errorf("Channel connet fail: %s", err)
		return err
	}
	r.channel = c
	beeLogger.Log.Success("RabbitMQ Server is running...")

	return nil
}

func (r *RabbitMQ) mqClose() {
	if r.channel != nil {
		err := r.channel.Close()
		if err != nil {
			beeLogger.Log.Errorf("RabbitMQ Server Close Err: %s", err)
		}
	}
	if r.connection != nil {
		err := r.connection.Close()
		if err != nil {
			beeLogger.Log.Errorf("RabbitMQ Server Channel Close Err: %s", err)
		}
	}
}

func (r *RabbitMQ) Send(req map[string]interface{}) error {
	//defer r.mqClose()

	bytes, err := json.Marshal(req)
	if err != nil {
		return err
	}
	return r.channel.Publish("X.ofc.ppt2image", "RK.ofc.ppt2image", false, false, amqp.Publishing{
		ContentType: "text/plain",
		Body:        bytes,
	})

}

func init() {
	once.Do(func() {
		RM = NewRabbitmq()
	})

}
func NewRabbitmq() *RabbitMQ{
	return &RabbitMQ{}
}

