// @APIVersion 1.0.0
// @Title beego Test API
// @Description beego has a very cool tools to autogenerate documents for your API
// @Contact astaxie@gmail.com
// @TermsOfServiceUrl http://beego.me/
// @License Apache 2.0
// @LicenseUrl http://www.apache.org/licenses/LICENSE-2.0.html
package routers

import (
	"encoding/json"
	"ppt_server/controllers"
	"github.com/astaxie/beego/context"
	"github.com/astaxie/beego"
	"ppt_server/upload"
)

func init() {
	beego.Router("/file/upload", &controllers.UploadController{})

	beego.Post("/file/callback", func(ctx *context.Context) {
		var mapFiles map[string]interface{}
		var err error
		if err = json.Unmarshal(ctx.Input.RequestBody, &mapFiles); err != nil {
			ctx.WriteString("Error " + err.Error())
			return
		}
		if err = upload.CreateFileDataBase(mapFiles); err != nil {
			ctx.WriteString("Error " + err.Error())
			return
		}
		ctx.WriteString("Upload Ok")
	})
}
