package controllers

import (
	"github.com/astaxie/beego"
	"ppt_server/models"
	"ppt_server/upload"
)

type Response struct {
	Code   int    `json:"code"`
	Msg    string `json:"msg"`
}


type UploadController struct {
	beego.Controller
}

func (this *UploadController) newResponse(code int, msg string) {
	response := &Response{
		Code: code,
	}
	if msg != "" {
		response.Msg = msg
	}
	this.Data["json"] = response
	this.ServeJSON()
}

func (this *UploadController) Get() {
	this.newResponse(200, "成功")
}

func (this *UploadController) Post() {

	u := models.XyuSmallTempFiles{}
	if err := this.ParseForm(&u); err != nil {
		//handle error
		this.newResponse(100, "参数绑定失败")
		return
	}
	if u.RoomNum == "" || u.Uuid == "" || u.Url == "" {
		this.newResponse(100, "参数不正确")
		return
	}
	go upload.Upload(&u)
	this.newResponse(200, "成功")
	return
	//fmt.Println(u)
}