/**
* @Authore: lifeifei
* @Date: 2021/7/23 2:48 下午
 */
package oss

import (
	"io"
	"os"
	"sync"

	"github.com/aliyun/aliyun-oss-go-sdk/oss"
	"github.com/gogf/gf/frame/g"
)

var (
	client *oss.Client
	bucket *oss.Bucket
	once   sync.Once
)

func init() {
	once.Do(func() {
		client, _ = oss.New(g.Cfg().GetString("oss.point"),
			os.Getenv("s_access_id"), os.Getenv("s_access_secret"))
		bucket, _ = client.Bucket(g.Cfg().GetString("oss.bucket"))
	})
}

//OSS上传
func Upload(path string, reader io.Reader) error {
	return bucket.PutObject(path, reader)
}
