package boot

import (
	"os"

	"github.com/gogf/gf/database/gdb"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/net/ghttp"
)

func init() {
	gdb.SetConfig(gdb.Config{
		"default": gdb.ConfigGroup{
			gdb.ConfigNode{
				Host:    os.Getenv("read_sql"),
				Port:    "3306",
				User:    os.Getenv("read_user"),
				Pass:    os.Getenv("read_pass"),
				Type:    "mysql",
				Name:    "xyu",
				Charset: "utf8mb4",
			},
		},
	})
	g.Server().SetNameToUriType(ghttp.URI_TYPE_CAMEL)

	g.Log().SetAsync(true)
}
