package internal

import (
	"github.com/gogf/gf/database/gdb"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/frame/gmvc"
)

type xyuRoomColumns struct {
	Id      string
	RoomNum string
}

type XyuRoomDao struct {
	gmvc.M
	DB      gdb.DB
	Table   string
	Columns xyuRoomColumns
}

var (
	XyuRoom = XyuRoomDao{
		M:     g.DB("default").Model("xyu_room").Safe(),
		DB:    g.DB("default"),
		Table: "xyu_room",
		Columns: xyuRoomColumns{
			Id:      "id",
			RoomNum: "room_num",
		},
	}
)
