/**
* @Authore: lifeifei
* @Date: 2021/7/21 4:26 下午
 */
package http

import (
	"net/http"
	"net/http/cookiejar"
	"time"

	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/net/ghttp"
)

// 保持会话请求
type SessionHttpClient struct {
	c *ghttp.Client
}

func NewSessionHttpClient() *SessionHttpClient {
	jar, _ := cookiejar.New(nil)
	c := g.Client()
	c.Jar = jar
	c.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		return http.ErrUseLastResponse
	}
	return &SessionHttpClient{c}
}

func (client *SessionHttpClient) Post(link string, data ...interface{}) ([]byte, error) {
	return Handle(client.c.Timeout(10*time.Second).Post(link, data))
}

func (client *SessionHttpClient) Get(url string) ([]byte, error) {
	return Handle(client.c.Timeout(10 * time.Second).Get(url))

}
