package service

import (
	"ppt_server/app/dao"
	"ppt_server/app/model"
	"ppt_server/packed/file"

	"github.com/gogf/gf/frame/g"
)

var File = &fileService{
	done: make(chan error),
	ok:   make(chan g.Map),
}

type fileService struct {
	done chan error
	ok   chan g.Map
}

// 上传课件
func (f *fileService) Upload(r *model.FileUploadRequest) {
	// 解析上传课件URL

	parserURLObject, err := file.Upload(r, f.done, f.ok)
	if err != nil {
		g.Log().Async().Errorf("Parser Url err: %s\n", err)
		return
	}
	// 检查房间是否存在
	var room model.XyuRoom
	if err = dao.XyuRoom.Where(dao.XyuRoom.Columns.RoomNum, r.RoomNum).Scan(&room); err != nil {
		g.Log().Async().Error(err)
		go func() { f.done <- err }()
	}
	// 上传操作
	go parserURLObject.Worker(err)

	// 回调通知
	n := file.NewNotify()
	select {
	case <-f.done:
		// 上传失败
		n.Fail(parserURLObject)
		return
	case res := <-f.ok:
		// 上传成功
		count, err := dao.XyuRoomFile.Where(dao.XyuRoomFile.Columns.RoomId, room.Id).
			Where(dao.XyuRoomFile.Columns.Name, r.Name).Count()
		if err != nil {
			g.Log().Async().Errorf("Mysql Err: %s\n", err)
			return
		}
		// 数据库已经存在不需要通知
		if count == 1 {
			return
		}
		res["room_id"] = room.Id
		n.Success(res)
		return
	}
}
