package middleware

import (
	"bytes"
	"io/ioutil"

	"ppt_server/library/response"

	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/net/ghttp"
)

// Recover异常恢复
func Recover(r *ghttp.Request) {
	r.Middleware.Next()
	if err := r.GetError(); err != nil {
		r.Response.ClearBuffer()
		response.Fail(r, err)
	}
}

// CorS跨域
func Cors(r *ghttp.Request) {
	r.Response.CORSDefault()
	r.Middleware.Next()
}

// BodyDump打印请求体
func BodyDump(r *ghttp.Request) {
	reqBody, _ := ioutil.ReadAll(r.Request.Body)
	r.Request.Body = ioutil.NopCloser(bytes.NewBuffer(reqBody))
	if len(reqBody) > 0 {
		g.Log().Async().Infof("path: %s, method: %s params: %s",
			r.Request.URL.RequestURI(), r.Method, string(reqBody))
	}
	r.Middleware.Next()

}
