package http

import (
	"io"
	"net/http"
	"os"
	"time"

	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/net/ghttp"
)

func Get(url string) ([]byte, error) {
	return Handle(g.Client().Timeout(30 * time.Second).Get(url))
}

func Handle(response *ghttp.ClientResponse, err error) ([]byte, error) {
	if err != nil {
		return nil, err
	}
	defer response.Close()

	return response.ReadAll(), nil
}

// 下载文件
func Download(file string, path string) error {
	g.Log().Async().Infof("Download zip url: %s ", file)
	resp, err := http.Get(file)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	// 创建一个文件用于保存
	out, err := os.Create(path)
	if err != nil {
		return err
	}
	defer out.Close()

	// 然后将响应流和文件流对接起来
	_, err = io.Copy(out, resp.Body)

	if err != nil && err == io.EOF {
		return nil
	}
	if err != nil {
		return err
	}
	return nil
}
