package internal

import (
	"github.com/gogf/gf/database/gdb"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/frame/gmvc"
)

type xyuRoomFilesColumns struct {
	Id     string
	RoomId string
	Name   string
}

type XyuRoomFilesDao struct {
	gmvc.M
	DB      gdb.DB
	Table   string
	Columns xyuRoomFilesColumns
}

var (
	XyuRoomFiles = XyuRoomFilesDao{
		M:     g.DB("default").Model("xyu_room_files").Safe(),
		DB:    g.DB("default"),
		Table: "xyu_room_files",
		Columns: xyuRoomFilesColumns{
			Id:     "id",
			RoomId: "room_id",
			Name:   "name",
		},
	}
)
