package file

import (
	"fmt"
	"mime"
	"path"
	"strings"

	"github.com/gogf/gf/encoding/gurl"
	"github.com/gogf/gf/errors/gerror"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/text/gstr"
)

type parser struct {
	path      string
	slicePath []string
	url       string //课件地址
	ext       string //课件后缀
	name      string //课件名称

}

func parseURL(ossFileLink string) (*parser, error) {

	parseURLPath, err := gurl.ParseURL(ossFileLink, 32)

	if err != nil {
		return nil, err
	}
	slicePath := gstr.SplitAndTrim(parseURLPath["path"], "/", "/")

	if len(slicePath) < 4 {
		return nil, gerror.New("上传URL格式不正确")
	}
	f := &parser{
		ext:       path.Ext(ossFileLink),
		url:       ossFileLink,
		path:      parseURLPath["path"],
		slicePath: slicePath,
		name:      path.Base(ossFileLink),
	}

	return f, nil
}

//解析课件的URL
func (f *parser) splitFileInfoLink() string {
	return fmt.Sprintf("%s?info=0&ssl=1&furl=%s/%s",
		ParserFileLink, g.Cfg().GetString("oss.url"), f.dataPath())
}

// 临时存储解析包地址
func (f *parser) splitTempZipLink() string {
	return fmt.Sprintf("%s%s.zip", g.Cfg().GetString("temp.path"), f.slicePath[2])
}

// 获取文件名称
func (f *parser) filename() string {
	return f.name
}

// 上传课件路径
func (f *parser) splitUploadPath() string {
	return strings.Join(f.slicePath[0:len(f.slicePath)-1], "/") + "/"
}

// 文件名称hash
func (f *parser) nameHash() string {
	return f.slicePath[3]
}

// 文件内容hash
func (f *parser) contentHash() string {
	return f.slicePath[2]
}

// 数据库存储path
func (f *parser) dataPath() string {
	return  f.splitUploadPath() + gurl.Encode(f.slicePath[len(f.slicePath)-1:][0])
}

// 解析doctype
func (f *parser) docType() string {
	switch f.ext {
	case ".ppt", ".pptx":
		return "4"
	case ".doc", ".docx":
		return "2"
	case ".xls", ".xlsx":
		return "3"
	case ".pdf":
		return "1"
	default:
		return "1"
	}
}

// 获取文件mine
func (f *parser) mineType() string {
	_ = mime.AddExtensionType(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation")
	_ = mime.AddExtensionType(".ppt", "application/vnd.ms-powerpoint")
	return mime.TypeByExtension(f.ext)
}
