/**
* @Authore: lifeifei
* @Date: 2021/7/21 3:08 下午
 */
package response

import (
	"net/http"

	"github.com/gogf/gf/errors/gerror"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/net/ghttp"
	"github.com/gogf/gf/util/gvalid"
)

func Success(r *ghttp.Request, data ...interface{}) {
	res := g.Map{
		"code": 0,
		"msg":  "成功",
		"data": nil,
	}
	if len(data) > 0 {
		res["data"] = data[0]
	}
	_ = r.Response.WriteJsonExit(res)
}

func Fail(r *ghttp.Request, err error) {
	switch e := err.(type) {
	case gvalid.Error:
		_ = r.Response.WriteJsonExit(g.Map{
			"code": http.StatusBadRequest,
			"msg":  e.FirstString(),
		})
	case *gerror.Error:
		_ = r.Response.WriteJsonExit(g.Map{
			"code": e.Code(),
			"msg":  e.Error(),
		})
	default:
		_ = r.Response.WriteJsonExit(g.Map{
			"code": http.StatusInternalServerError,
			"msg":  e.Error(),
		})
	}

}
