package utils

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"os"
	"time"
)

type RabbitMqConf struct {
	Username         string
	Password         string
	Host             string
	Port             int
	ConfFilePath     string
	Driver           string
	DBHost           string
	DBPort           string
	DBpass           string
	DBuser           string
	DBname           string
	DBcharset        string
	DBprefix         string
	ReconnectionTime time.Duration

	MaxFreeLink int
	MaxLink     int
}

var ConfigObject *RabbitMqConf

func (r *RabbitMqConf) Reload() {
	if confFileExists, _ := PathExists(r.ConfFilePath); !confFileExists {
		fmt.Println("Config File ", r.ConfFilePath, " is not exist!!")
		return
	}

	data, err := ioutil.ReadFile(r.ConfFilePath)
	if err != nil {
		panic(err)
	}
	//将json数据解析到struct中
	err = json.Unmarshal(data, r)
	if err != nil {
		panic(err)
	}
}

//判断一个文件是否存在

func PathExists(path string) (bool, error) {
	_, err := os.Stat(path)
	if err == nil {
		return true, nil
	}
	if os.IsNotExist(err) {
		return false, nil
	}
	return false, err
}

func init() {
	//ConfigObject = &RabbitMqConf{
	//	Host:             os.Getenv("rb_host"),
	//	Username:         os.Getenv("rb_user"),
	//	Password:         os.Getenv("rb_pass"),
	//	DBHost:           os.Getenv("write_sql"),
	//	DBuser:           os.Getenv("write_user"),
	//	DBpass:           os.Getenv("write_pass"),
	//	Port:             5672,
	//	ConfFilePath:     "conf/rmq.conf",
	//	ReconnectionTime: 10 * time.Second,
	//}
	//ConfigObject.Reload()
	ConfigObject = &RabbitMqConf{
		DBHost:           "rm-2zevlk47ul0ovuci80o.mysql.rds.aliyuncs.com",
		DBuser:           "video",
		DBpass:           "vlty&AxMwT$lmLv6bN8dkDuBYlh%N5pe",
		DBPort:           "3306",
		DBname:           "xyu",
		Driver:           "mysql",
		DBcharset:        "utf8",
		Username:         "admin",
		Password:         "admin",
		Host:             "192.168.10.156",
		Port:             5672,
		ConfFilePath:     "conf/rmq.conf",
		ReconnectionTime: 1 * time.Second,
	}

}
