package validator_struct

import "im-microservice/pb"

// 添加配置的参数检测
type ConfigureAddStruct struct {
	CompanyUserId   int64  `validate:"required,numeric"`
	MultideviceType int64  `validate:"required,numeric"`
	MsgHookUrl      string `validate:"required"`
}

func NewConfigureAddStruct(in *pb.ConfigureRequest) *ConfigureAddStruct {
	return &ConfigureAddStruct{
		CompanyUserId:   in.Public.GetCompanyUserId(),
		MultideviceType: in.Public.GetMultideviceType(),
		MsgHookUrl:      in.Public.GetMsgHookUrl(),
	}
}

// 修改配置
type ConfigureUpdateStruct struct {
	CompanyUserId   int64 `validate:"required,numeric"`
	MultideviceType int64
	MsgHookUrl      string
}

func NewConfigureUpdateStruct(in *pb.UpdateRequest) *ConfigureUpdateStruct {
	return &ConfigureUpdateStruct{
		CompanyUserId:   in.Public.GetCompanyUserId(),
		MultideviceType: in.Public.GetMultideviceType(),
		MsgHookUrl:      in.Public.GetMsgHookUrl(),
	}
}

// 删除配置
type ConfigureDelStruct struct {
	CompanyUserId int64 `validate:"required,numeric"`
}

func NewConfigureDelStruct(in *pb.ConfigureDelRequest) *ConfigureDelStruct {
	return &ConfigureDelStruct{CompanyUserId: in.GetCompanyUserId()}
}

// 创建聊天室

type ChatRoomAddStruct struct {
	Creator      string `validate:"required"`
	Name         string `validate:"required"`
	Announcement string `validate:"required"`
}

func NewAddChatRoom(in *pb.ChatRoomAddRequest) *ChatRoomAddStruct {
	return &ChatRoomAddStruct{
		Creator:      in.GetCreator(),
		Name:         in.GetName(),
		Announcement: in.GetAnnouncement(),
	}
}

// 修改聊天室

type ChatRoomUpdate struct {
	RoomId       int64 `validate:"required"`
	Name         string
	Announcement string
	Status       int64
}

func NewChatRoomUpdate(in *pb.ChatRoomUpdateRequest) *ChatRoomUpdate {
	return &ChatRoomUpdate{
		RoomId:       in.GetRoomId(),
		Name:         in.GetName(),
		Announcement: in.GetAnnouncement(),
		Status:       in.GetStatus(),
	}
}

// 删除聊天室

type ChatRoomDel struct {
	RoomId int64 `validate:"required"`
}

func NewChatRoomDel(in *pb.ChatRoomDelRequest) *ChatRoomDel {
	return &ChatRoomDel{RoomId: in.GetRoomId()}
}

// 获取单个聊天室
type ChatRoomInfo struct {
	RoomId       int64 `validate:"required"`
	Creator      string
	Name         string
	Announcement string
	Status       int64
	Ext          string
	Createtime   string
	Updatetime   string
}

func NewChatRoomInfo(in *pb.ChatRoomInfoRequest) *ChatRoomInfo {
	return &ChatRoomInfo{RoomId: in.GetRoomId()}
}

