package im_configure

import (
	"context"
	"errors"

	"im-microservice/helper"
	"im-microservice/pb"
	vs "im-microservice/validator_struct"
)

type ConfigureSevice struct {
	pb.UnimplementedConfigureSeviceServer
}

func (cs *ConfigureSevice) Add(ctx context.Context, in *pb.ConfigureRequest) (reply *pb.ConfigureReply, err error) {

	configure_add_struct := vs.NewConfigureAddStruct(in)
	if err = helper.Valiator(configure_add_struct); err != nil {
		return
	}
	// 已经添加过配置无需在添加
	if _, err = helper.GetImBaseByUserId(configure_add_struct.CompanyUserId); err == nil {
		err = errors.New("已经添加过配置,无需再添加")
		return
	}
	// 添加配置
	if err = helper.AddImBase(configure_add_struct); err != nil {
		return
	}
	reply = &pb.ConfigureReply{}
	return
}

func (cs *ConfigureSevice) Delete(ctx context.Context, in *pb.ConfigureDelRequest) (reply *pb.ConfigureReply, err error) {

	cds := vs.NewConfigureDelStruct(in)
	if err = helper.Valiator(cds); err != nil {
		return
	}
	// 执行删除操作
	if err = helper.DelConfigure(cds.CompanyUserId); err != nil {
		return
	}
	reply = &pb.ConfigureReply{}
	return
}

func (cs *ConfigureSevice) Select(ctx context.Context, in *pb.GetAllRequest) (reply *pb.GetAllReply, err error) {

	reply = &pb.GetAllReply{}
	configs := helper.GetConfigureAll()

	if len(configs) > 0 {
		for _, v := range configs {

			reply.GetAll = append(reply.GetAll, &pb.GetAllOneReply{
				Reply: &pb.Public{
					CompanyUserId:   v.CompanyUserId,
					MultideviceType: v.MultideviceType,
					MsgHookUrl:      v.MsgHookUrl,
				},
			})
		}
	}
	return
}

func (cs *ConfigureSevice) Update(ctx context.Context, in *pb.UpdateRequest) (reply *pb.ConfigureReply, err error) {

	configure_add_struct := vs.NewConfigureUpdateStruct(in)
	if err = helper.Valiator(configure_add_struct); err != nil {
		return
	}
	// 更新数据
	if err = helper.UpdateConfiguer(configure_add_struct); err != nil {
		return
	}
	reply = &pb.ConfigureReply{}
	return
}