package helper

import (
	"context"
	"errors"
	"im-microservice/db"
	"log"
	"math"
	"time"

	"gopkg.in/go-playground/validator.v9"
)

func Valiator(in interface{}) error {
	validate := validator.New()

	err := validate.Struct(in)
	if err != nil {
		for _, err := range err.(validator.ValidationErrors) {
			log.Println("error == ", err)
			return errors.New("表单验证失败")
		}
	}
	return nil
}

func GetNowTime() string {
	return time.Now().Format("2006-01-02 15:04:05")
}

var ctx = context.Background()

func GetCode(mobile string) (string, error) {
	val, err := db.RedisClient.Get(ctx, mobile).Result()
	if err != nil {
		return "", err
	}

	return val, nil
}

func Paginate(count, step, page int64) (int64, int64) {
	offset := step * (page - 1)
	total := int64(math.Ceil(float64(count) / float64(step)))
	return offset, total
}
