package db

import (
	"fmt"
	"log"
	"sync"

	"github.com/astaxie/beego/orm"
	"github.com/go-redis/redis/v8"

	_ "github.com/go-sql-driver/mysql"
)

var (
	RedisClient *redis.Client
	once        sync.Once
	MysqlClient orm.Ormer
)

var (
	redis_host = "192.168.10.20:6379"
	redis_pass = "test.eoffcn.com"
	redis_db   = 13

	mysql_host    = "rm-2zevlk47ul0ovuci80o.mysql.rds.aliyuncs.com"
	mysql_user    = "video"
	mysql_pass    = "vlty&AxMwT$lmLv6bN8dkDuBYlh%N5pe"
	mysql_port    = "3306"
	mysql_db      = "media_microservice"
	mysql_charset = "utf8"
	mysql_driver  = "mysql"
)

func init() {
	once.Do(func() {
		newRedisClient()
		newMysqlClient()
	})
}

func newRedisClient() {
	RedisClient = redis.NewClient(&redis.Options{
		Addr:     redis_host,
		Password: redis_pass, // no password set
		DB:       redis_db,   // use default DB
	})
}

func newMysqlClient() {
	dbConfStr := fmt.Sprintf("%s:%s@tcp(%s:%s)/%s?charset=%s",
		mysql_user, mysql_pass, mysql_host, mysql_port, mysql_db, mysql_charset)
	_ = orm.RegisterDriver(mysql_driver, orm.DRMySQL)
	err := orm.RegisterDataBase("default", mysql_driver, dbConfStr, 10, 100)
	if err != nil {
		log.Println("db connect error => ", err)
		return
	}
	orm.RegisterModel(new(CompanyApp), new(ImBase), new(ImChatRoom), new(ImUser))
	MysqlClient = orm.NewOrm()
	log.Println("MySQL connect success")
}
