package im_friend_request

import (
	"github.com/astaxie/beego/orm"
	"im-microservice/db"
	"im-microservice/helper"
	"im-microservice/pb"
)

var (
	table_name = "im_friend_request"
	field_id = "id"
	field_accid = "accid"
	field_faccid = "faccid"
	field_status = "status"
	field_updatetime = "updatetime"

)
const(
	field_status_wait = iota
	field_status_agree
	field_status_refuse
)

func All(accid string) ([]db.ImFriendRequest, error){
	var list []db.ImFriendRequest
	_, err := db.MysqlClient.QueryTable(table_name).Filter(field_accid, accid).
		Filter(field_status, field_status_wait).All(&list)
	return list, err
}

func FindExits(accid, faccid string) bool {
	return db.MysqlClient.QueryTable(table_name).
		Filter(field_accid, accid).
		Filter(field_faccid, faccid).
		Filter(field_status,field_status_wait).Exist()
}

func AddRecord(in *pb.ImFriendAddReq) error {
	var (
		db_friend db.ImFriendRequest
	)
	now := helper.GetNowTime()
	db_friend.Faccid = in.Faccid
	db_friend.Accid = in.Accid
	db_friend.Status = field_status_wait
	db_friend.Createtime = now
	db_friend.Updatetime = now
	_, err := db.MysqlClient.Insert(&db_friend)
	return err
}

func Update(in *pb.ImFriendUpdateReq) error {
	orm_params := make(orm.Params)
	orm_params[field_status] = in.Status
	orm_params[field_updatetime] = helper.GetNowTime()
	_, err := db.MysqlClient.QueryTable(table_name).Filter(field_id, in.Id).Filter(field_status, field_status_wait).Update(orm_params)
	return err
}
