package im_chat_room_user

import (
	"errors"
	"im-microservice/db"
	"im-microservice/helper"
	"im-microservice/pb"

	"github.com/astaxie/beego/orm"
	"google.golang.org/grpc/status"
)

const (
	cr_table_name = "im_chat_room_user"
)

//查询房间创建者
func GetChatRoomUserOper(room_id int64) (db.ImChatRoomUser, error) {
	var r_user db.ImChatRoomUser
	err := db.MysqlClient.QueryTable(cr_table_name).Filter("room_id", room_id).Filter("role", 0).One(&r_user)
	if err != nil {
		return r_user, err
	}
	return r_user, nil
}

//查询房间用户信息
func GetChatRoomUser(room_id int64, accid string) (db.ImChatRoomUser, error) {
	var r_user db.ImChatRoomUser
	err := db.MysqlClient.QueryTable(cr_table_name).Filter("room_id", room_id).Filter("accid", accid).One(&r_user)
	if err != nil {
		return r_user, err
	}
	return r_user, nil
}

//添加用户
func AddChatRoomUser(room_id int64, accid string, oper bool) (db.ImChatRoomUser, error) {
	var r_user db.ImChatRoomUser
	r_user.RoomId = room_id
	r_user.Accid = accid
	r_user.Role = 2
	r_user.Createtime = helper.GetNowTime()
	if oper == true {
		r_user.Operator = accid
		r_user.Role = 0
	}
	_, err := db.MysqlClient.Insert(&r_user)
	if err != nil {
		return r_user, err
	}
	return r_user, nil
}

//设置用户
func SetChatRoomUser(in *pb.RoomUserSetRoleRequest) error {
	orm_params := make(orm.Params)
	orm_params["role"] = in.GetRole()
	orm_params["operator"] = in.GetOperator()
	orm_params["updatetime"] = helper.GetNowTime()
	res, err := db.MysqlClient.QueryTable(cr_table_name).Filter("room_id", in.GetRoomId()).Filter("accid", in.GetAccid()).Update(orm_params)
	if res != 1 {
		err = errors.New("修改数据失败")
		return err
	}
	return nil
}

//获取房间用户列表
func GetChatRoomUserList(request *pb.RoomUserListRequest) (results map[string]interface{}, err error) {
	var (
		page    = request.GetPage()
		room_id = request.GetRoomId()
		role    = request.GetRole()
		accid   = request.GetAccid()
	)
	if page == 0 {
		page = 1
	}
	count_db := db.MysqlClient.QueryTable(cr_table_name)
	count_db = count_db.Filter("room_id", room_id)
	if role != 0 {
		count_db = count_db.Filter("role", role)
	}

	if accid != "" {
		count_db = count_db.Filter("accid", accid)
	}

	ctn, err := count_db.Count()
	if err != nil {
		return
	}
	if ctn == 0 {
		err = errors.New("没有查询到任何数据")
		return
	}
	//获取
	offset, total_page := helper.Paginate(ctn, 20, page)

	// 查询数据
	var c_user []db.ImChatRoomUser
	if _, err = count_db.Limit(20, offset).All(&c_user); err != nil {
		return
	}
	results = make(map[string]interface{})
	results["list"] = c_user
	results["total_page"] = total_page
	results["total_count"] = ctn
	results["page"] = page
	results["page_size"] = 20
	return
}

//删除用户
func DelChatRoomUser(room_id int64, accid string) error {
	_, err := db.MysqlClient.QueryTable(cr_table_name).Filter("room_id", room_id).Filter("accid", accid).Delete()
	if err != nil {
		err = status.Error(500, err.Error())
	}
	return err
}
