package helper

import (
	"context"
	"log"
	"math"
	"time"

	"im-microservice/db"

	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"gopkg.in/go-playground/validator.v9"
)

func Valiator(in interface{}) error {
	validate := validator.New()

	err := validate.Struct(in)
	if err != nil {
		for _, err := range err.(validator.ValidationErrors) {
			log.Println("error == ", err)
			return status.Error(codes.PermissionDenied, "表单验证失败")
		}
	}
	return nil
}

func GetNowTime() string {
	return time.Now().Format("2006-01-02 15:04:05")
}

var ctx = context.Background()

func GetCode(mobile string) (string, error) {
	val, err := db.RedisClient.Get(ctx, mobile).Result()
	if err != nil {
		return "", err
	}

	return val, nil
}

func Paginate(count, step, page int64) (int64, int64) {
	offset := step * (page - 1)
	total := int64(math.Ceil(float64(count) / float64(step)))
	return offset, total
}


func TimeOutCanceled(ctx context.Context) (err error) {
	select {
	case <-ctx.Done():
		err = status.Error(codes.Canceled, "Client cancelled, abandoning.")
		break
	}
	return
}