package im_user

import (
	//"fmt"
	//"errors"
	"im-microservice/db"
	"im-microservice/helper"

	//"im-microservice/pb"

	"github.com/astaxie/beego/orm"
	"google.golang.org/grpc/status"
)

const (
	ul_table_name   = "im_user_login"
	ul_user_id      = "user_id"
	ul_login_status = "login_status"
	ul_updatetime   = "updatetime"
	ul_platform     = "platform"
)

//用户登录处理
func LoginHandle(user_id int64, platform string) (db.ImUserLogin, error) {
	//查询该设备平台是否已经存在数据
	log_user, err := GetLogin(user_id, platform)
	if err != nil {
		//插入数据
		log_user.LoginStatus = 1
		log_user.Platform = platform
		log_user.Updatetime = helper.GetNowTime()
		log_user.UserId = user_id
		_, err := db.MysqlClient.Insert(&log_user)
		if err != nil {
			return log_user, err
		}
	} else {
		//修改数据
		if err := UpdateLogin(user_id, platform, 1); err != nil {
			return log_user, err
		}
		log_user.LoginStatus = 1
	}
	return log_user, nil
}

//用户退出
func LoginOutHandle(user_id int64, platform string) (db.ImUserLogin, error) {
	//查询登录信息
	log_user, err := GetLogin(user_id, platform)
	if err != nil {
		err = status.Error(500, "用户还没有登录信息")
		return log_user, err
	}
	//修改
	if err := UpdateLogin(user_id, platform, 0); err != nil {
		return log_user, err
	}
	return log_user, nil
}

//查询
func GetLogin(user_id int64, platform string) (db.ImUserLogin, error) {
	var log_user db.ImUserLogin
	err := db.MysqlClient.QueryTable(ul_table_name).Filter(ul_user_id, user_id).Filter(ul_platform, platform).One(&log_user)
	if err != nil {
		return log_user, err
	}
	return log_user, nil
}

//修改
func UpdateLogin(user_id int64, platform string, login_status int64) error {
	orm_params := make(orm.Params)
	orm_params[ul_login_status] = login_status
	orm_params[ul_updatetime] = helper.GetNowTime()
	_, err := db.MysqlClient.QueryTable(ul_table_name).Filter(ul_user_id, user_id).Filter(ul_platform, platform).Update(orm_params)
	if err != nil {
		err = status.Error(500, err.Error())
		return err
	}
	return err
}
