package im_configure

import (
	"context"
	"errors"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"

	"im-microservice/helper"
	"im-microservice/pb"
	vs "im-microservice/validator_struct"
)

type ConfigureSevice struct {
	pb.UnimplementedConfigureSeviceServer
}

func (cs *ConfigureSevice) Add(ctx context.Context,
	in *pb.ConfigureRequest) (reply *pb.ConfigureReply, err error) {
	// 请求超时
	if ctx.Err() == context.Canceled {
		err = status.New(codes.Canceled, "Client cancelled, abandoning.").Err()
		return
	}
	configure_add_struct := vs.NewConfigureAddStruct(in)
	if err = helper.Valiator(configure_add_struct); err != nil {
		return
	}
	// 已经添加过配置无需在添加
	if _, err = GetImBaseByUserId(configure_add_struct.CompanyUserId); err == nil {
		err = errors.New("已经添加过配置,无需再添加")
		return
	}
	if ok := helper.AppIsExit(configure_add_struct.AppId); !ok {
		err = errors.New("appid不存在")
		return
	}
	// 添加配置
	if err = AddImBase(configure_add_struct); err != nil {
		return
	}
	reply = &pb.ConfigureReply{}
	return
}

func (cs *ConfigureSevice) Delete(ctx context.Context,
	in *pb.ConfigureDelRequest) (reply *pb.ConfigureReply, err error) {
	// 请求超时
	if ctx.Err() == context.Canceled {
		err = status.New(codes.Canceled, "Client cancelled, abandoning.").Err()
		return
	}
	// 执行删除操作
	if err = DelConfigure(in.CompanyUserId); err != nil {
		return
	}
	reply = &pb.ConfigureReply{}
	return
}

func (cs *ConfigureSevice) Select(ctx context.Context,
	in *pb.GetAllRequest) (reply *pb.GetAllReply, err error) {
	// 请求超时
	if ctx.Err() == context.Canceled {
		err = status.New(codes.Canceled, "Client cancelled, abandoning.").Err()
		return
	}
	reply = &pb.GetAllReply{}

	configs, err := GetConfigureAll()
	if err != nil {
		return
	}
	if len(configs) == 0 {
		return
	}
	for _, v := range configs {
		reply.GetAll = append(reply.GetAll, &pb.GetAllOneReply{
			Reply: &pb.Public{
				CompanyUserId:   v.CompanyUserId,
				MultideviceType: v.MultideviceType,
				MsgHookUrl:      v.MsgHookUrl,
			},
		})
	}

	return
}

func (cs *ConfigureSevice) Update(ctx context.Context,
	in *pb.UpdateRequest) (reply *pb.ConfigureReply, err error) {
	// 请求超时
	if ctx.Err() == context.Canceled {
		err = status.New(codes.Canceled, "Client cancelled, abandoning.").Err()
		return
	}
	configure_add_struct := vs.NewConfigureUpdateStruct(in)
	if err = helper.Valiator(configure_add_struct); err != nil {
		return
	}
	// 更新数据
	if err = UpdateConfiguer(configure_add_struct); err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.ConfigureReply{}
	return
}
