package im_chat_room_user

import (
	"context"
	"im-microservice/db"

	//"im-microservice/helper"
	"im-microservice/pb"

	"google.golang.org/grpc/status"
)

type ChatRoomUserServer struct {
	pb.UnimplementedChatRoomUserServer
}

//添加创建者
func (c *ChatRoomUserServer) AddOperator(ctx context.Context, in *pb.RoomUserAddOpeRequest) (reply *pb.RoomUserReply, err error) {
	//查询房间是否已经添加过了
	if r_user, _ := GetChatRoomUserOper(in.GetRoomId()); r_user.Accid != "" {
		err = status.Error(20438, "该聊天室已存在管理员")
		return
	}

	//添加创建者
	r_user, err := AddChatRoomUser(in.GetRoomId(), in.GetOperator(), true)
	if err != nil {
		err = status.Error(500, "添加创建者失败")
		return
	}
	reply = &pb.RoomUserReply{}
	reply.RoomId = r_user.RoomId
	reply.Operator = r_user.Operator
	reply.Accid = r_user.Accid
	reply.Role = r_user.Role
	return
}

//添加普通用户
func (c *ChatRoomUserServer) ChatRoomUserAdd(ctx context.Context, in *pb.RoomUserAddRequest) (reply *pb.RoomUserReply, err error) {
	//查询是否已经有了
	if r_user, _ := GetChatRoomUser(in.GetRoomId(), in.GetAccid()); r_user.Accid != "" {
		err = status.Error(20438, "聊天室已存在该用户")
		return
	}

	//添加用户
	r_user, err := AddChatRoomUser(in.GetRoomId(), in.GetAccid(), false)
	if err != nil {
		err = status.Error(500, "聊天室添加用户失败")
		return
	}
	reply = &pb.RoomUserReply{}
	reply.RoomId = r_user.RoomId
	reply.Accid = r_user.Accid
	reply.Role = r_user.Role
	return
}

//设置用户角色
func (c *ChatRoomUserServer) ChatRoomUserSetRole(ctx context.Context, in *pb.RoomUserSetRoleRequest) (reply *pb.RoomUserReply, err error) {
	//获取操作者信息
	o_user, err := GetChatRoomUser(in.GetRoomId(), in.GetOperator())
	if err != nil {
		err = status.Error(404, "该操作者不存在")
		return
	}
	switch in.GetRole() {
	//设为管理员
	case 1:
		if o_user.Role != 0 {
			err = status.Error(403, "不是创建者不能设置管理员")
			return
		}
	default:
		if o_user.Role > 1 {
			err = status.Error(403, "没有操作权限")
			return
		}

	}

	//查询该用户是否存在
	check_u, err := GetChatRoomUser(in.GetRoomId(), in.GetAccid())
	if err != nil {
		err = status.Error(404, "不是该聊天室用户")
		return
	}

	if check_u.Role == in.GetRole() {
		err = status.Error(417, "已经是该种角色了，不用重复设置")
		return
	}

	//设置权限
	err = SetChatRoomUser(in)
	if err != nil {
		return
	}
	reply = &pb.RoomUserReply{}
	reply.RoomId = check_u.RoomId
	reply.Operator = in.GetOperator()
	reply.Accid = check_u.Accid
	reply.Role = in.GetRole()
	return
}

//获取单个用户
func (c *ChatRoomUserServer) ChatRoomUserOne(ctx context.Context, in *pb.RoomUserOneRequest) (reply *pb.RoomUserOneReply, err error) {
	c_user, err := GetChatRoomUser(in.GetRoomId(), in.GetAccid())
	if err != nil {
		return
	}
	reply = &pb.RoomUserOneReply{}
	reply = getOneData(c_user)
	return
}

func getOneData(c_user db.ImChatRoomUser) *pb.RoomUserOneReply {
	return &pb.RoomUserOneReply{
		Id:         int64(c_user.Id),
		RoomId:     int64(c_user.RoomId),
		Operator:   c_user.Operator,
		Accid:      c_user.Accid,
		Role:       c_user.Role,
		Createtime: c_user.Createtime,
		Updatetime: c_user.Updatetime,
	}
}

//获取房间用户列表
func (c *ChatRoomUserServer) ChatRoomUserList(ctx context.Context, in *pb.RoomUserListRequest) (reply *pb.RoomUserListReply, err error) {
	results, err := GetChatRoomUserList(in)
	if err != nil {
		return
	}

	reply = &pb.RoomUserListReply{Paginate: &pb.Page{}}

	c_user_list := results["list"].([]db.ImChatRoomUser)
	for _, v := range c_user_list {
		reply.List = append(reply.List, getOneData(v))
	}

	reply.Paginate.PageSize = int64(results["page_size"].(int))
	reply.Paginate.PagetNo = results["page"].(int64)
	reply.Paginate.TotalCount = results["total_count"].(int64)
	reply.Paginate.TotalPage = results["total_page"].(int64)
	return
}

//删除
func (c *ChatRoomUserServer) ChatRoomUserDel(ctx context.Context, in *pb.RoomUserOneRequest) (reply *pb.RoomUserDelReply, err error) {
	if err = DelChatRoomUser(in.GetRoomId(), in.GetAccid()); err != nil {
		return
	}
	reply = &pb.RoomUserDelReply{}
	return
}
