package middleware

import (
	"context"
	"time"

	"golang.org/x/time/rate"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

func Interceptor(ctx context.Context, req interface{}, info *grpc.UnaryServerInfo,
	handler grpc.UnaryHandler) (interface{}, error) {

	if info.FullMethod != health_path {
		limiter := rate.NewLimiter(rate.Every(100*time.Millisecond), 1)
		if limiter.Allow() {
			return handler(ctx, req)
		} else {
			return nil, status.Error(codes.Unauthenticated, "请求超过限制,请稍后再试")
		}
	}
	return handler(ctx, req)
}
