package main

import (
	"net"

	initialize "im-microservice/initialization"

	beeLogger "github.com/beego/bee/logger"
)

const (
	port = ":50051"
)

func main() {

	lis, err := net.Listen("tcp", port)
	if err != nil {
		beeLogger.Log.Fatalf("failed to listen: %v", err)
	}

	beeLogger.Log.Success("gRPC server is running on " + port + " port.")
	if err := initialize.RpcServer.Serve(lis); err != nil {
		beeLogger.Log.Fatalf("failed to serve: %v", err)

	}

}
