package helper

import "im-microservice/db"

const (
	table_name = "company_app"
	app_name   = "name"
	app_key    = "key"
	app_secret = "secret"
	app_cid    = "cid"
)

func GetSecretByKey(key string) (error, string) {
	var u_app db.CompanyApp
	err := db.MysqlClient.QueryTable(table_name).Filter(app_key, key).One(&u_app, app_secret)
	if err != nil {
		return err, ""
	}
	return nil, u_app.Secret
}


func AppIsExit(appid int64) bool {
	return db.MysqlClient.QueryTable(table_name).Filter("id", appid).Exist()
}