package im_user_relationship

import (
	"context"

	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"im-microservice/sevice/im_user"

	"im-microservice/helper"
	"im-microservice/pb"
)

type UserRelationshipService struct {
	pb.UnimplementedUserRelationshipServiceServer
}

func (us *UserRelationshipService) Add(ctx context.Context,
	in *pb.UserRelationshipAddRequest) (reply *pb.UserRelationshipAddReply, err error) {

	if ok := IsUserRelationship(in.Accid, in.Faccid); ok {
		err = status.Error(codes.AlreadyExists, "已经添加过该好友")
		return
	}
	//添加好友
	if err = AddUserRelationship(in); err != nil {
		return
	}
	// 更改用户版本信息
	u_map := make(map[string]interface{})
	u_map["edition"] = helper.GetNowTime()
	_, _ = im_user.UpdateImUser(in.Accid, u_map)

	reply = &pb.UserRelationshipAddReply{}
	return
}

func (us *UserRelationshipService) Delete(ctx context.Context,
	in *pb.UserRelationshipDelRequest) (reply *pb.UserRelationshipAddReply, err error) {

	// 删除好友
	if err = DBDelete(in); err != nil {
		return
	}
	// 更改用户版本信息
	u_map := make(map[string]interface{})
	u_map["edition"] = helper.GetNowTime()
	_, _ = im_user.UpdateImUser(in.Accid, u_map)

	reply = &pb.UserRelationshipAddReply{}
	return
}

func (us *UserRelationshipService) All(ctx context.Context,
	in *pb.UserRelationshipListRequest) (reply *pb.UserRelationshipListReply, err error) {

	results, err := DBAll(in)
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.UserRelationshipListReply{}
	for _, v := range results {
		reply.List = append(reply.List, &pb.UserRelationshipInfo{
			Faccid:     v.Faccid,
			Updatetime: v.Updatetime,
		})
	}
	return
}

func (us *UserRelationshipService) SetSpecialRelation(ctx context.Context,
	in *pb.SetSpecialRelationReq) (reply *pb.UserRelationshipAddReply, err error) {

	if err = SetSpecialRelationDb(in); err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.UserRelationshipAddReply{}
	return
}

func (us *UserRelationshipService) ListBlackAndMuteList(ctx context.Context,
	in *pb.ListBlackAndMuteListReq) (reply *pb.ListBlackAndMuteListReply, err error) {

	blacklist, mutelist, err := ListBlackAndMuteListDB(in)
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.ListBlackAndMuteListReply{}

	if len(blacklist) > 0 {
		for _, v := range blacklist {
			reply.Blacklist = append(reply.Blacklist,
				&pb.UserRelationshipInfo{Updatetime: v.Updatetime, Faccid: v.Faccid})
		}
	}
	if len(mutelist) > 0 {
		for _, v := range mutelist {
			reply.Mutelist = append(reply.Mutelist,
				&pb.UserRelationshipInfo{Updatetime: v.Updatetime, Faccid: v.Faccid})
		}
	}
	return
}
