package im_user

import (
	"bytes"
	"crypto/md5"
	"encoding/hex"
	"errors"
	"fmt"
	"im-microservice/db"
	"im-microservice/helper"
	"im-microservice/pb"
	"math/rand"
	"time"

	"github.com/astaxie/beego/orm"
	"github.com/segmentio/ksuid"
)

const (
	u_table_name = "im_user"
)

func CreateCaptcha() string {
	return fmt.Sprintf("%04v", rand.New(rand.NewSource(time.Now().UnixNano())).Int31n(10000))
}

func createAccid() string {
	var buffer bytes.Buffer
	kid := ksuid.New()
	buffer.WriteString(kid.String())
	buffer.WriteString(CreateCaptcha())
	h := md5.New()
	h.Write([]byte(buffer.String()))
	return hex.EncodeToString(h.Sum(nil))
}

//通过手机号获取用户数据
func GetImUserByMobile(mobile string) (db.ImUser, error) {
	var c_user db.ImUser
	fmt.Println(db.MysqlClient)
	err := db.MysqlClient.QueryTable(u_table_name).Filter("mobile", mobile).One(&c_user)
	if err != nil {
		return c_user, err
	}
	return c_user, nil
}

//im用户注册
func CreateImUser(name string, mobile string) (db.ImUser, error) {
	accid := createAccid()
	var c_user db.ImUser
	c_user.Accid = accid
	c_user.Name = name
	c_user.Mobile = mobile
	c_user.Createtime = helper.GetNowTime()
	_, err := db.MysqlClient.Insert(&c_user)
	if err != nil {
		return c_user, err
	}

	return c_user, nil
}

//用户登录更新登录信息
func SaveUpdatetime(mobile string, platform string) (int64, error) {
	updatetime := helper.GetNowTime()
	orm_params := make(orm.Params)
	orm_params["login_status"] = 1
	orm_params["updatetime"] = updatetime
	orm_params["platform"] = platform
	res, err := db.MysqlClient.QueryTable(u_table_name).Filter("mobile", mobile).Update(orm_params)
	if err != nil {
		return 0, err
	}
	return res, nil
}

//修改用户信息
func UpdateImUser(accid string, m map[string]interface{}) (int64, error) {
	orm_params := make(orm.Params)
	for k, v := range m {
		switch v.(type) {
		case int:
			i_v := v.(int)
			orm_params[k] = i_v
		case string:
			s_v := v.(string)
			orm_params[k] = s_v
		case int64:
			c_v := v.(int64)
			orm_params[k] = c_v
		}
	}
	res, err := db.MysqlClient.QueryTable(u_table_name).Filter("accid", accid).Update(orm_params)
	if err != nil {
		return 0, err
	}
	return res, nil
}

//获取用户信息
func GetImUserByAccid(accid string) (db.ImUser, error) {
	var c_user db.ImUser
	fmt.Println(db.MysqlClient)
	err := db.MysqlClient.QueryTable(u_table_name).Filter("accid", accid).One(&c_user)
	if err != nil {
		return c_user, err
	}
	return c_user, nil
}

//获取用户列表
func GetImUserList(request *pb.ImUserListRequest) (results map[string]interface{}, err error) {
	var (
		mobile           = request.GetMobile()
		name             = request.GetName()
		disable          = request.GetDisable()
		mute_estoppel    = request.GetMuteEstoppel()
		mute_audio_video = request.GetMuteAudioVideo()
		ext              = request.GetExt()
		login_status     = request.GetLoginStatus()
		platform         = request.GetPlatform()
		page             = request.GetPage()
		edition          = request.GetEdition()
	)
	if page == 0 {
		page = 1
	}
	count_db := db.MysqlClient.QueryTable(u_table_name)
	if name != "" {
		count_db = count_db.Filter("name__icontains", name)
	}
	if mobile != "" {
		count_db = count_db.Filter("mobile", mobile)
	}
	if disable != 0 {
		count_db = count_db.Filter("disable", disable)
	}
	if mute_estoppel != 0 {
		count_db = count_db.Filter("mute_estoppel", mute_estoppel)
	}
	if mute_audio_video != 0 {
		count_db = count_db.Filter("mute_audio_video", mute_audio_video)
	}
	if ext != "" {
		count_db = count_db.Filter("ext__icontains", ext)
	}
	if login_status != 0 {
		count_db = count_db.Filter("login_status", login_status)
	}
	if platform != "" {
		count_db = count_db.Filter("platform", platform)
	}
	if edition != "" {
		count_db = count_db.Filter("edition", edition)
	}
	ctn, err := count_db.Count()
	if err != nil {
		return
	}
	if ctn == 0 {
		err = errors.New("没有查询到任何数据")
		return
	}
	//获取
	offset, total_page := helper.Paginate(ctn, 20, page)

	// 查询数据
	var im_user []db.ImUser
	if _, err = count_db.Limit(20, offset).All(&im_user); err != nil {
		return
	}
	results = make(map[string]interface{})
	results["list"] = im_user
	results["total_page"] = total_page
	results["total_count"] = ctn
	results["page"] = page
	results["page_size"] = 20
	return
}
