package health

import (
	"context"
	"sync"

	"im-microservice/pb"

	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

type Health interface {
	// Check returns if server is healthy or not
	Check(c context.Context) (bool, error)
}

// 健康检测
type Server struct {
	mu        sync.Mutex
	statusMap map[string]pb.HealthCheckResponse_ServingStatus
}

func (s *Server) Check(ctx context.Context, in *pb.HealthCheckRequest) (*pb.HealthCheckResponse, error) {
	s.mu.Lock()
	defer s.mu.Unlock()
	if in.Service == "" {
		return &pb.HealthCheckResponse{Status: pb.HealthCheckResponse_SERVING}, nil
	}
	if status, ok := s.statusMap[in.Service]; ok {
		return &pb.HealthCheckResponse{Status: status}, nil
	}
	return nil, status.Error(codes.NotFound, "unkonw service")
}

func NewServer() *Server {
	return &Server{
		statusMap: make(map[string]pb.HealthCheckResponse_ServingStatus),
	}
}
